//+------------------------------------------------------------------+
//|                                                    C_Manager.mqh |
//|                                                      Daniel Jose |
//|                                                                  |
//+------------------------------------------------------------------+
#property copyright "Daniel Jose"
//+------------------------------------------------------------------+
#include "C_ControlOfTime.mqh"
#include "..\System EA\Auxiliar\Study\C_Study.mqh"
//+------------------------------------------------------------------+
#define def_Prefix "Manager"
#define def_LINE_PRICE 	def_Prefix + "_PRICE"
#define def_LINE_TAKE	def_Prefix + "_TAKE"
#define def_LINE_STOP	def_Prefix + "_STOP"
//+------------------------------------------------------------------+
#define def_AcessTerminal 	(*Terminal)
#define def_InfoTerminal 	def_AcessTerminal.GetInfoTerminal()
#define def_AcessMouse		(*Study)
#define def_InfoMouse		def_AcessMouse.GetInfoMouse()
//+------------------------------------------------------------------+
class C_Manager : public C_ControlOfTime
{
	private	:
		struct st00
		{
			double	FinanceStop,
						FinanceTake;
			uint		Leverage;
			bool		IsDayTrade,
						AccountHedging;						
		}m_Infos;
		struct st01
		{
			color		corPrice,
						corTake,
						corStop;
			bool		bCreate;
		}m_Objects;		
//+------------------------------------------------------------------+
		C_Terminal	*Terminal;
		C_Study		*Study;
//+------------------------------------------------------------------+
		bool CreateOrder(const ENUM_ORDER_TYPE type, const double Price)
			{
				ulong tmp;
				
				if (!CtrlTimeIsPassed()) return false;
				tmp = C_Orders::CreateOrder(type, Price, m_Infos.FinanceStop, m_Infos.FinanceTake, m_Infos.Leverage, m_Infos.IsDayTrade);
				
				return tmp > 0;
			}
//+------------------------------------------------------------------+  
		bool ToMarket(const ENUM_ORDER_TYPE type)
			{
				ulong tmp;
				
				if (!CtrlTimeIsPassed()) return false;
				tmp = C_Orders::ToMarket(type, m_Infos.FinanceStop, m_Infos.FinanceTake, m_Infos.Leverage, m_Infos.IsDayTrade);
				
				return tmp > 0;
			}
//+------------------------------------------------------------------+
	public	:
//+------------------------------------------------------------------+
		C_Manager(C_Terminal *arg1, C_Study *arg2, color cPrice, color cStop, color cTake, const ulong magic, const double FinanceStop, const double FinanceTake, uint Leverage, bool IsDayTrade)
			:C_ControlOfTime(arg1, magic)
			{
				string szInfo = "HEDGING";
				
				Terminal = arg1;
				Study = arg2;
				if (CheckPointer(Terminal) == POINTER_INVALID) SetUserError(C_Terminal::ERR_PointerInvalid);
				if (CheckPointer(Study) == POINTER_INVALID) SetUserError(C_Terminal::ERR_PointerInvalid);
				if (_LastError != ERR_SUCCESS) return;
				m_Infos.FinanceStop 		= FinanceStop;
				m_Infos.FinanceTake 		= FinanceTake;
				m_Infos.Leverage    		= Leverage;
				m_Infos.IsDayTrade  		= IsDayTrade;
				m_Infos.AccountHedging 	= false;
				m_Objects.corPrice		= cPrice;
				m_Objects.corStop			= cStop;
				m_Objects.corTake			= cTake;
				m_Objects.bCreate			= false;
				switch ((ENUM_ACCOUNT_MARGIN_MODE)AccountInfoInteger(ACCOUNT_MARGIN_MODE))
				{
					case ACCOUNT_MARGIN_MODE_RETAIL_HEDGING: m_Infos.AccountHedging = true;	break;
					case ACCOUNT_MARGIN_MODE_RETAIL_NETTING: szInfo = "NETTING"; 				break;
					case ACCOUNT_MARGIN_MODE_EXCHANGE		: szInfo = "EXCHANGE";				break;
				}
				Print("Detected Account ", szInfo);
			}
//+------------------------------------------------------------------+
		~C_Manager()
			{
				ObjectsDeleteAll(def_InfoTerminal.ID, def_Prefix);
			}
//+------------------------------------------------------------------+
		void DispatchMessage(const int id, const long &lparam, const double &dparam, const string &sparam)
			{
				static double price = 0;
				bool bBuy, bSell;
				
				def_AcessTerminal.DispatchMessage(id, lparam, dparam, sparam);
				def_AcessMouse.DispatchMessage(id, lparam, dparam, sparam);
				switch (id)
				{
					case CHARTEVENT_KEYDOWN:
						if (TerminalInfoInteger(TERMINAL_KEYSTATE_CONTROL))
						{
							if (TerminalInfoInteger(TERMINAL_KEYSTATE_UP))	ToMarket(ORDER_TYPE_BUY);
							if (TerminalInfoInteger(TERMINAL_KEYSTATE_DOWN))ToMarket(ORDER_TYPE_SELL);
						}
						break;
					case CHARTEVENT_MOUSE_MOVE:
						bBuy = def_AcessMouse.CheckClick(C_Mouse::eSHIFT_Press);
						bSell = def_AcessMouse.CheckClick(C_Mouse::eCTRL_Press);
						if (bBuy != bSell)
						{
							if (!m_Objects.bCreate)
							{
								def_AcessTerminal.CreateObjectGraphics(def_LINE_PRICE, OBJ_HLINE, m_Objects.corPrice, 0);
								def_AcessTerminal.CreateObjectGraphics(def_LINE_STOP, OBJ_HLINE, m_Objects.corStop, 0);
								def_AcessTerminal.CreateObjectGraphics(def_LINE_TAKE, OBJ_HLINE, m_Objects.corTake, 0);
								EventChartCustom(def_InfoTerminal.ID, C_Mouse::ev_HideMouse, 0, 0, "");
								m_Objects.bCreate = true;
							}
							ObjectMove(def_InfoTerminal.ID, def_LINE_PRICE, 0, 0, def_InfoMouse.Position.Price);
							ObjectMove(def_InfoTerminal.ID, def_LINE_TAKE, 0, 0, def_InfoMouse.Position.Price + (Terminal.FinanceToPoints(m_Infos.FinanceTake, m_Infos.Leverage) * (bBuy ? 1 : -1)));
							ObjectMove(def_InfoTerminal.ID, def_LINE_STOP, 0, 0, def_InfoMouse.Position.Price + (Terminal.FinanceToPoints(m_Infos.FinanceStop, m_Infos.Leverage) * (bSell ? 1 : -1)));
							if ((def_AcessMouse.CheckClick(C_Mouse::eClickLeft)) && (price == 0)) CreateOrder((bBuy ? ORDER_TYPE_BUY : ORDER_TYPE_SELL), price = def_InfoMouse.Position.Price);
						}else if (m_Objects.bCreate)
						{
							EventChartCustom(def_InfoTerminal.ID, C_Mouse::ev_ShowMouse, 0, 0, "");
							ObjectsDeleteAll(def_InfoTerminal.ID, def_Prefix);
							m_Objects.bCreate = false;
							price = 0;
						}
						break;
				}
			}
//+------------------------------------------------------------------+
};
//+------------------------------------------------------------------+
#undef def_AcessMouse
#undef def_InfoMouse
#undef def_AcessTerminal
#undef def_InfoTerminal
//+------------------------------------------------------------------+
#undef def_Prefix
#undef def_LINE_PRICE
#undef def_LINE_TAKE
#undef def_LINE_STOP
//+------------------------------------------------------------------+
